<#ibiztemplate>
TARGET=PSDELOGIC
</#ibiztemplate>
package ${pub.getPKGCodeName()}.${de.getPSSystemModule().codeName?lower_case}.logic.${de.codeName?lower_case}logic.${item.getCodeName()?lower_case};

<#assign logicName=(de.codeName+item.codeName)?lower_case>
<#assign delogic=item>
<#assign defaultLogicParam="">
        <#comment>插入逻辑参数</#comment>
        <#if delogic.getPSDELogicParams?? && delogic.getPSDELogicParams()??>
import java.util.Map;
            <#list delogic.getPSDELogicParams() as logicParam>
                <#if logicParam.isDefault()==true>
                    <#assign defaultLogicParam=logicParam><#comment>获取处理逻辑中默认逻辑参数</#comment>
                </#if>
                <#if logicParam.getParamPSDataEntity?? && logicParam.getParamPSDataEntity()??>
                    <#assign ParamPSDataEntity=logicParam.getParamPSDataEntity()>
global ${pub.getPKGCodeName()}.${ParamPSDataEntity.getPSSystemModule().codeName?lower_case}.domain.${ParamPSDataEntity.codeName} ${logicName+logicParam.codeName?lower_case};
                <#else>
global java.util.Map ${logicName+logicParam.codeName?lower_case};
                </#if>
            </#list>
        </#if>
        <#comment>插入处理逻辑中所用到的service对象</#comment>
        <#if delogic.getPSDELogicNodes?? && delogic.getPSDELogicNodes()??>
            <#list delogic.getPSDELogicNodes() as deLogicNode>
            <#if deLogicNode.getDstPSDataEntity?? && deLogicNode.getDstPSDataEntity()??>
                <#if !P.exists("kieSession",deLogicNode.getDstPSDataEntity().getCodeName()?lower_case,"service")>
                <#assign DstPSDataEntity=deLogicNode.getDstPSDataEntity()>
global ${pub.getPKGCodeName()}.${DstPSDataEntity.getPSSystemModule().codeName?lower_case}.service.${DstPSDataEntity.codeName}Service ${deLogicNode.getDstPSDataEntity().getCodeName()?lower_case}service;
                </#if>
            </#if>
            </#list>
            <#comment>插入当前实体的defaultService对象，供自定义查询使用</#comment>
global ${pub.getPKGCodeName()}.${de.getPSSystemModule().codeName?lower_case}.service.${de.codeName}Service iBzSys${de.codeName?lower_case?cap_first}DefaultService;
        </#if>

no-loop
        <#if delogic.getPSDELogicNodes?? && delogic.getPSDELogicNodes()??>
            <#list delogic.getPSDELogicNodes() as deLogicNode>

rule "${deLogicNode.getName()?lower_case}"
ruleflow-group "${logicName+deLogicNode.getCodeName()?lower_case}"
    when
    then
            <#if deLogicNode.codeName !='Begin'><#comment>开始节点不输出内容</#comment>
                <#if deLogicNode.getLogicNodeType()=='PREPAREPARAM' && deLogicNode.getPSDELogicNodeParams()??><#comment>准备参数</#comment>
                    <#list deLogicNode.getPSDELogicNodeParams() as nodeParam>
                        <#assign targetLogicParam=nodeParam.getDstPSDELogicParam()>
                        <#assign targetLogicField=nodeParam.getDstFieldName()>
                        <#if nodeParam.getSrcValueType()=='SRCVALUE'><#comment>直接值</#comment>
    ${logicName+targetLogicParam.getCodeName()?lower_case}.set("${targetLogicField?lower_case}","${nodeParam.getSrcValue()}");<#comment>通过set赋值，避免类型转换</#comment>
                        <#elseif nodeParam.getSrcValueType()=='SRCDLPARAM' ><#comment>源逻辑参数</#comment>
                            <#assign  srcPSDELogicParam=nodeParam.getSrcPSDELogicParam()>
                            <#assign  srcFieldName=nodeParam.getSrcFieldName()>
                            <#if srcPSDELogicParam.getParamPSDataEntity?? && srcPSDELogicParam.getParamPSDataEntity()??>
    ${logicName+targetLogicParam.getCodeName()?lower_case}.set${targetLogicField?lower_case?cap_first}(${logicName+srcPSDELogicParam.getCodeName()?lower_case}.get${srcFieldName?lower_case?cap_first}());<#comment>源逻辑参数选择了实体</#comment>
                            <#else>
    ${logicName+targetLogicParam.getCodeName()?lower_case}.set("${targetLogicField?lower_case}",${logicName+srcPSDELogicParam.getCodeName()?lower_case}.get("${srcFieldName?upper_case}"));<#comment>源逻辑参数无实体，从Map中get</#comment>
                            </#if>
                        <#elseif nodeParam.getSrcValueType()=='WEBCONTEXT'><#comment>网页请求上下文</#comment>
                            <#if defaultLogicParam??>
                                <#assign sqlParam=logicName+defaultLogicParam.codeName?lower_case+".extensions.get(\"${(nodeParam.getSrcFieldName())!''}\")">
    ${logicName+targetLogicParam.getCodeName()?lower_case}.set("${targetLogicField?lower_case}",${sqlParam});
                            <#else>
    ${logicName+targetLogicParam.getCodeName()?lower_case}.set${targetLogicField?lower_case?cap_first}("");
                            </#if>
                        <#elseif nodeParam.getSrcValueType()=='DATACONTEXT'><#comment>数据上下文</#comment>
                            <#if defaultLogicParam??>
                                <#assign sqlParam=logicName+defaultLogicParam.codeName?lower_case+".extensions.get(\"${(nodeParam.getSrcFieldName())!''}\")">
    ${logicName+targetLogicParam.getCodeName()?lower_case}.set("${targetLogicField?lower_case}",${sqlParam});
                            <#else>
    ${logicName+targetLogicParam.getCodeName()?lower_case}.set${targetLogicField?lower_case?cap_first}("");
                            </#if>
                        <#elseif nodeParam.getSrcValueType()=='SESSION'><#comment>用户全局对象</#comment>
                                <#assign sqlParam=pub.getPKGCodeName()+".ibizutil.security.AuthenticationUser.getAuthenticationUser().getSessionParams().get(\"${(nodeParam.getSrcFieldName()?lower_case)!''}\")">
    ${logicName+targetLogicParam.getCodeName()?lower_case}.set("${targetLogicField?lower_case}",${sqlParam});
                        <#else><#comment>暂未支持其余准备参数设置</#comment>
    ${logicName+targetLogicParam.getCodeName()?lower_case}.set${targetLogicField?lower_case?cap_first}("");
                        </#if>
                    </#list>
                <#elseif deLogicNode.getLogicNodeType()=='DEACTION'><#comment>调用实体行为</#comment>
                    <#assign  operateEntity=deLogicNode.getDstPSDataEntity()><#comment>操作实体</#comment>
                    <#assign  operateAction=deLogicNode.getDstPSDEAction()><#comment>操作行为</#comment>
                    <#assign  operateParam=deLogicNode.getDstPSDELogicParam()><#comment>操作参数</#comment>
    ${operateEntity.codeName?lower_case}service.${operateAction.codeName?lower_case}(${logicName+operateParam.codeName?lower_case});
                <#elseif deLogicNode.getLogicNodeType()=='RAWSQLCALL'><#comment>直接SQL</#comment>
                    <#if deLogicNode.getPSDELogicNodeParams()??><#comment>是否包含参数列表</#comment>
    String strSql=${getCallSQL(deLogicNode)};
                    <#else>
    String strSql="${srfjavasqlcode('${deLogicNode.getParam("PARAM4","")}')}";
                    </#if>
    java.util.List<Map<String,Object>> entities=iBzSys${de.codeName?lower_case?cap_first}DefaultService.selectRow(strSql);//SQL调用
                    <#if  deLogicNode.getDstPSDELogicParam?? && deLogicNode.getDstPSDELogicParam()?? ><#comment>配置返回参数</#comment>
    if(entities.size()>0){
                        <#assign targetLogicParam=deLogicNode.getDstPSDELogicParam()>
        Map<String,Object> entity=entities.get(0);<#comment>获取返回参数</#comment>
                        <#if targetLogicParam.getParamPSDataEntity?? && targetLogicParam.getParamPSDataEntity()??>
                            <#assign targetEntity=targetLogicParam.getParamPSDataEntity()>
                            <#if (deLogicNode.getParam("PARAM7",1)==0)><#comment>重置原数据</#comment>
        ${pub.getPKGCodeName()}.${targetEntity.getPSSystemModule().codeName?lower_case}.domain.${targetEntity.codeName} targetEntity =new ${pub.getPKGCodeName()}.${targetEntity.getPSSystemModule().codeName?lower_case}.domain.${targetEntity.codeName}();
        for (Map.Entry<String,Object> entry : entity.entrySet()) {
            targetEntity.set(entry.getKey(),entry.getValue());
        }
        org.springframework.cglib.beans.BeanCopier copier= org.springframework.cglib.beans.BeanCopier.create(targetEntity.getClass(),${logicName+targetLogicParam.getCodeName()?lower_case}.getClass(), false);
        copier.copy(targetEntity,${logicName+targetLogicParam.getCodeName()?lower_case},null);
                            <#else><#comment>不重置原数据</#comment>
        for (Map.Entry<String,Object> entry : entity.entrySet()) {
            ${logicName+targetLogicParam.getCodeName()?lower_case}.set(entry.getKey(),entry.getValue());
        }
                            </#if>
                        <#else>
        ${logicName+targetLogicParam.codeName?lower_case}.putAll(entity);
                        </#if>
    }
                    </#if>
            <#elseif  deLogicNode.getLogicNodeType()=='RAWSQLANDLOOPCALL'><#comment>直接SQL并循环调用</#comment>
                    <#if deLogicNode.getPSDELogicNodeParams()??><#comment>是否包含参数列表</#comment>
    String strSql=${getCallSQL(deLogicNode)};
                    <#else>
    String strSql="${srfjavasqlcode('${deLogicNode.getParam("PARAM4","")}')}";
                    </#if>
    java.util.List<Map<String,Object>> entities=iBzSys${de.codeName?lower_case?cap_first}DefaultService.selectRow(strSql);//SQL调用
    if(entities.size()>0){
                        <#if deLogicNode.getDstPSDataEntity?? && deLogicNode.getDstPSDataEntity()?? &&deLogicNode.getDstPSDEAction?? && deLogicNode.getDstPSDEAction()??>
                            <#assign targetEntity=deLogicNode.getDstPSDataEntity()>
                            <#assign targetAction=deLogicNode.getDstPSDEAction()>
        for(Map<String,Object> entity:entities){
            ${pub.getPKGCodeName()}.${targetEntity.getPSSystemModule().codeName?lower_case}.domain.${targetEntity.codeName} targetEntity =new ${pub.getPKGCodeName()}.${targetEntity.getPSSystemModule().codeName?lower_case}.domain.${targetEntity.codeName}();
            for (Map.Entry<String,Object> entry : entity.entrySet()) {
                targetEntity.set(entry.getKey(),entry.getValue());
            }
            ${targetEntity.codeName?lower_case}service.${targetAction.codeName?lower_case}(targetEntity);
        }
                        </#if>
    }
                </#if>
                <#if delogic.getPSDELogicParams?? && delogic.getPSDELogicParams()??>
                    <#list delogic.getPSDELogicParams() as logicParam>
    update(${logicName+logicParam.codeName?lower_case});//更新fact中变量值
                    </#list>
                </#if>
            </#if>
    end
            </#list>
        </#if>

<#comment>获取String.format拼接的sql</#comment>
<#function getCallSQL deLogicNode>
    <#assign sql=srfjavasqlcode('${deLogicNode.getParam("PARAM4","")}')>
    <#assign strSQL="String.format(\""+sql+"\",">
    <#list deLogicNode.getPSDELogicNodeParams() as nodeParam>
        <#assign  sqlParam="">
        <#if nodeParam.getSrcValueType()=='SRCDLPARAM'><#comment>源逻辑参数</#comment>
            <#assign  srcPSDELogicParam=nodeParam.getSrcPSDELogicParam()>
            <#assign  srcFieldName=nodeParam.getSrcFieldName()>
            <#if srcPSDELogicParam.getParamPSDataEntity?? && srcPSDELogicParam.getParamPSDataEntity()??><#comment>源逻辑参数选择了实体</#comment>
                 <#assign sqlParam=logicName+srcPSDELogicParam.getCodeName()?lower_case+".get"+srcFieldName?lower_case?cap_first+"()">
            </#if>
        <#elseif nodeParam.getSrcValueType()=='WEBCONTEXT'><#comment>网页请求上下文</#comment>
            <#if defaultLogicParam??>
                <#assign sqlParam=logicName+defaultLogicParam.codeName?lower_case+".extensions.get(\"${(nodeParam.getSrcFieldName())!''}\")">
            <#else>
                <#assign sqlParam="null">
            </#if>
        <#elseif nodeParam.getSrcValueType()=='SESSION'><#comment>用户全局对象</#comment>
            <#assign sqlParam=pub.getPKGCodeName()+".ibizutil.security.AuthenticationUser.getAuthenticationUser().getSessionParams().get(\"${(nodeParam.getSrcFieldName()?lower_case)!''}\")">
        <#elseif nodeParam.getSrcValueType()=='DATACONTEXT'><#comment>数据上下文</#comment>
            <#if defaultLogicParam??>
                <#assign sqlParam=logicName+defaultLogicParam.codeName?lower_case+".extensions.get(\"${(nodeParam.getSrcFieldName())!''}\")">
            <#else>
                <#assign sqlParam="null">
            </#if>
        <#elseif nodeParam.getSrcValueType()=='SRCVALUE'><#comment>直接值</#comment>
            <#assign sqlParam=nodeParam.getSrcValue()>
        <#else>
            <#assign sqlParam="null"><#comment>暂未支持其余准备参数设置</#comment>
        </#if>
        <#if nodeParam.getSrcValueType()=='SRCVALUE'>
            <#assign strSQL=strSQL+"\""+sqlParam+"\"">
        <#else>
            <#assign strSQL=strSQL+sqlParam>
        </#if>
        <#if nodeParam_has_next>
            <#assign strSQL=strSQL+",">
        </#if>
    </#list>
    <#assign strSQL=strSQL+")">
    <#return strSQL>
</#function>